function pi_models = build_transformers(idx_1, idx_2, A_n, V_n1, V_n2, r_sc, x_sc, V_b1, V_b2, A_b)
% 
% INPUT
%   idx_1       Index of bus where primary side is connected.
%   idx_2       Index of bus where secondary side is connected.
%   A_n         Nominal power.
%   V_n1        Primary-side nominal voltage.
%   V_n2        Sedondary-side nominal voltage.
%   r_sc        Short-circuit resistance in p.u.
%   x_sc        Short-circuit reactance in p.u.
%   V_b1        Primary-side base voltage in V.
%   V_b2        Secondary-side base voltage in V.
%   A_b         Base power in VA.
%
% OUPUT
%   pi_models   Per-unit pi-section equivalent circuits.

n_trafos = length(idx_1);

pi_models = cell(n_trafos,1);

for k=1:n_trafos    
    pi_k = struct();
    
    % **********
    
    % !!! write your own code here !!!
    
    pi_k.i      = [];
    pi_k.j      = [];
    pi_k.Y_ij   = [];
    pi_k.Y_i_ij = [];
    pi_k.Y_j_ij = [];
    
    % **********
    
    pi_models{k} = pi_k;
end

pi_models = [pi_models{:}];

end